#' Read catroads from shp file and write into PostgreSQL/PostGIS GPS database.
#'
#' Read catroads from shp file and write into PostgreSQL/PostGIS GPS database.
#' @param Operation Name of operation
#' @param CatRoadShp Array with folder and name of shape file. File name does not require  file extension. E.g., c("Z:\\SARP_DataArchive\\GPSStudy\\MPS\\GISTemp", "MPS_catroads"). Shape file need to have the following columns: id, incl_gps, name. 
#' @param DBType Optional parameter for specifying which database type the cat roads should be imported to. Values can be 'Main' (default) or 'NodeJS'.
#' @param Overwrite Boolean flag for whether the entire catroad table should be overwritten (i.e., all records deleted first). Default is F.

#' @export

importCatRoadsFromShp <- function(Operation, CatRoadShp, DBType="Main", Overwrite=F) {

  SPDF_CatRoads <- readOGR(CatRoadShp[1], CatRoadShp[2])
  
  SPDF_CatRoads@data <- SPDF_CatRoads@data[,-1]
  
  if (names(SPDF_CatRoads@data)[1] == "incl_gps" & names(SPDF_CatRoads@data)[2] == "name") {
    
    names(SPDF_CatRoads@data)[1] <- "incl_gps_processing"
    
    SPDF_CatRoads@data$uuid <- NA
    for (Index in 1:nrow(SPDF_CatRoads@data)) {
      SPDF_CatRoads@data$uuid[Index] <- createUuid()
    }
    
    if(Overwrite) {
      sendQueryToGPSDB(Operation, "Delete from loccat.catroads;", DBType=DBType)
    }
    
    writeSPDFToGPSDB(SPDF_CatRoads, Operation, "loccat", "catroads", DBType=DBType)
    
  }

}