#' Retrieve coding options from InfoEx and write into PostgreSQL/PostGIS GPS database.
#'
#' Retrieve coding options from InfoEx and write into PostgreSQL/PostGIS GPS database.
#' @param Operation Name of operation
#' @param DBType Optional variable for specifying which database type the location catalog should be imported. Values can be 'Main' (default) or 'NodeJS
#' @param Overwrite Boolean flag for whether the entire wxobs table should be overwritten (i.e., all records deleted first). Default is F.
#'
#' @export

importInfoExCodingOptions <- function(Operation, DBType="Main", Overwrite=F, SkipMissingLoc=F, Verbose=F, SuppressPostgreSQLWarnings=T) {
  
  ## Retrieve information from InfoEx
  require(SarpInfoExToolsPrivate)
  require(SarpInfoExTools)
  
  TblCodingOptions <- SarpInfoExTools::getInfoExCodingOptions(Operation, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)
  
  detach("package:SarpInfoExToolsPrivate", unload=TRUE)
  detach("package:SarpInfoExTools", unload=TRUE)
  
  print(paste0("Number of run coding retrieved from InfoEx: ", nrow(TblCodingOptions)))
  
  if(nrow(TblCodingOptions)>0) {
  
    ## Change name of columns
    colnames(TblCodingOptions)[which(colnames(TblCodingOptions)=="colour")] <- "clr"

    ## Delete existing records
    if (Overwrite) {
      print("Deleting existing records ...")
      sendQueryToGPSDB(Operation, "DELETE FROM runlist.code_definitions", DBType=DBType)
    }
 
    ## Writing table to GPSDB
    # TblCodingOptions <<- TblCodingOptions
    writeDFToGPSDB(DF=TblCodingOptions, Operation=Operation, Schema="runlist", DBTbl="code_definitions", DBType=DBType, Overwrite=Overwrite, ShowCounter=20, ObjLabel = "code option", Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)
    
  } else {
    
    warning("No coding options to import!", immediate. = T)
    
  }
    
}  