#' List raster references and array table
#'
#' Lists raster references and array table.
#' @param Operation Name of Operation. Used for accessing PostgreSQL database.
#' @param WithNumRecords Flag for whether the number of records in the array tabnles are included in the table. Default value is TRUE.
#' @return Dataframe with result
#' @export

listRasterRefAndArrayTbl <- function (Operation, WithNumRecords=T) {
  
  ## Default
  DBType <- "Main"

  ## Get raster list
  DF <- getRecordsFromQuery(Operation, "SELECT * FROM misc.rasters")

  ## Get number of records for each array table
  if(WithNumRecords) {
    DF$NumRecords <- NA
    for (i in 1:nrow(DF)) {
      DF$NumRecords[i] <- getRecordsFromQuery(Operation, paste0("SELECT COUNT(gpsruns_uuid) FROM gis.gpsruns_array_", DF$gis_array_name_ext[i]), DBType=DBType)
    }
  }

  return (DF)

}
