#' Plots RunsObject.
#'
#' Plots RunsObject.
#' @param RunsObject RunsObject object
#' @param WithObsPoints Switch for whether ObsPoints should be included. Default is TRUE.
#' @param WithPausePoints Switch for whether PausePoints should be included. Default is TRUE.
#' @param main Title for plot. Default is "GPS Tracks of Ski Runs".
#' 
#' @examples
#' require(SarpGPSTools)
#' require(SarpGPSToolsPrivate)
#' 
#' Operation <- "NEH"
#' RunUUIDs <- getRunUUIDsFromTrackerUnitAndDate(Operation, "13", "2015-02-02")
#' Runs <- getRunsObjectFromUUIDs(Operation, RunUUIDs)
#' plot(Runs, main="Runs tracked by Unit 13 on 2015-02-02")
#' plot(Runs, main="Runs tracked by Unit 13 on 2015-02-02", WithObsPoints=FALSE)
#' plot(Runs, main="Runs tracked by Unit 13 on 2015-02-02", WithObsPoints=FALSE, WithPausePoints=FALSE)
#' 
#' @export

plot.RunsObject <- function(RunsObject, WithObsPoints=T, WithPausePoints=T, main="GPS Tracks of Ski Runs") {
 
  options(warn=-1) ## to avoid error message regarding application of is.na to S4
  
  plot(RunsObject$Runs)
  
  if(!is.na(RunsObject$ObsPoints) & WithObsPoints) {
    points(RunsObject$ObsPoints, pch=4, cex=0.6, col="darkgrey")
  }
  
  lines(RunsObject$Runs, lwd=2)
  
  if(!is.na(RunsObject$PausePoints) & WithPausePoints) {
    points(RunsObject$PausePoints[RunsObject$PausePoints@data$activity=="GettingReady",], bg="red", pch=25)
    points(RunsObject$PausePoints[RunsObject$PausePoints@data$activity=="PackingUp",], bg="blue", pch=24)
    points(RunsObject$PausePoints[RunsObject$PausePoints@data$activity=="Waiting",], bg="darkgreen", pch=21)
  }
  
  
  box()
  title(main)
  
  options(warn=0)
  
}