#' Prints daily run use from GPS run tracks
#'
#' Prints daily run use from GPS run tracks. Requires that GPS runs have been processed with updateGPSRuns2LoccatLink() function.  
#' @param Operation Name of operation
#' @param DateStart Start date
#' @param DateEnd End date. Default is StartDate
#' @param Units Optional unit or list of units.
#' 
#' @examples 
#' require(SarpGPSTools)
#' require(SarpGPSToolsPrivate)
#' 
#' Operation <- "CMHGL"
#' DateStart <- "2017-12-15"
#' printDailyRunUse(Operation, DateStart)
#'
#' @export

printDailyRunUse <- function(Operation, DateStart, DateEnd=DateStart, Units=NA) {

  ## Build query
  if (is.na(Units[1])) {
    Query <- paste0("SELECT gps.qc_runs.date_local AS date, gps.qc_runs.runnum, gps.qc_runs.unit, gps.qc_runs.guide, gps.qc_runs.program, loccat.skilines.name AS skilinename, loccat.skiruns.name AS skirunname ",
                    "FROM gps.qc_runs LEFT JOIN loccat.skilines ON gps.qc_runs.loccatskilines_uuid = loccat.skilines.uuid LEFT JOIN loccat.skiruns ON gps.qc_runs.loccatskiruns_uuid = loccat.skiruns.uuid ",
                    "WHERE gps.qc_runs.date_local>='", DateStart, "' AND gps.qc_runs.date_local<='", DateEnd, "' ", 
                    "ORDER BY gps.qc_runs.date_local, gps.qc_runs.unit, gps.qc_runs.runnum")
  } else {
    Query <- paste0("SELECT gps.qc_runs.date_local AS date, gps.qc_runs.runnum, gps.qc_runs.unit, gps.qc_runs.guide, gps.qc_runs.program, loccat.skilines.name AS skilinename, loccat.skiruns.name AS skirunname ",
                    "FROM gps.qc_runs LEFT JOIN loccat.skilines ON gps.qc_runs.loccatskilines_uuid = loccat.skilines.uuid LEFT JOIN loccat.skiruns ON gps.qc_runs.loccatskiruns_uuid = loccat.skiruns.uuid ",
                    "WHERE gps.qc_runs.date_local>='", DateStart, "' AND gps.qc_runs.date_local<='", DateEnd, "' AND gps.qc_runs.unit = ANY('{", paste(Units, collapse = ","), "}') ", 
                    "ORDER BY gps.qc_runs.date_local, gps.qc_runs.unit, gps.qc_runs.runnum")
  }
  
  ## Get data
  Runs <- getRecordsFromQuery(Operation, Query)
  
  ## Name processing
  Runs$skilinename[is.na(Runs$skilinename)] <- ""
  Runs$skirunname[is.na(Runs$skirunname)] <- ""
  Runs$name <- paste0(Runs$skilinename, Runs$skirunname)
  Runs$name[Runs$name==""] <- "UNKNOWN"
  
  ## Create runlist string
  String <- "\n***********\n* RUN USE *\n***********\n"
  
  Dates <- unique(Runs$date)
  for (IndexDate in 1:length(Dates)) {
    
    Date <- Dates[IndexDate]
    
    Units <- unique(Runs$unit[Runs$date==Date])
    for (IndexUnit in 1:length(Units)) {
      
      Unit <- Units[IndexUnit]
      String <- paste0(String, "\n", Date, " - Unit ", Unit, "\n")
      String <- paste0(String, "*********************\n")
      
      DayRuns <- Runs[Runs$date==Date & Runs$unit==Unit,]
      
      for (IndexRun in 1:nrow(DayRuns)) {
        String <- paste0(String, DayRuns$runnum[IndexRun], ") ", DayRuns$name[IndexRun], "\n")
      }
  
    }
    
  }
  
  ## Output
  cat(String)
  
}