#' Check whether InfoEx records already exist in PostgreSQL/PostGIS GPS database and only return new records.
#'
#' Check whether InfoEx records already exist in PostgreSQL/PostGIS GPS database and only return new records.
#' @param DF_Import DF of Infoex records to be imported
#' @param ImportRelevantId Relevant ID in import data frame table (e.g., infoex_uuid (default), external_uuid)
#' @param ExistRelevantId Relevant ID in existing database table (e.g., infoex_uuid, external_uuid, uuid). Default is same as ImportRelevantId.
#' @param Operation Name of operation.
#' @param Schema Name of database schema that contains database table.
#' @param DBTbl Name of database table with geometry.
#' @export

returnNewExternalRecordsOnly <- function(DF_Import, ImportRelevantId="infoex_uuid", ExistRelevantId=ImportRelevantId, Operation, DBType="Main", Schema, DBTbl) {
 
  print(paste("Number of records in dataframe to be imported:", nrow(DF_Import)))
  
  DF_Output <- data.frame(uuid=character())
  
  ## Get existing records in target database
  DF_Exist <- getRecordsFromUUID(Operation=Operation, Schema=Schema, DBTbl=DBTbl, DBType=DBType, ResultCol = c(ExistRelevantId))
  print(paste("Number of existing records:", nrow(DF_Exist)))
  
  if (nrow(DF_Exist)==0) {
  
    DF_Output <- DF_Import
      
  } else {
  
    ## Filter observations
    DF_Output <- tryCatch(
      {DF_Import[!(DF_Import[,ImportRelevantId] %in% DF_Exist[,ExistRelevantId]),]},
      error=function(cond) {
        #message("Comparison results in error message --> likely empty spatial dataframe!")
        return(NULL)
      }
    )
  
  }

  if (is.null(DF_Output)) {
    message("Number of new records in dataframe to be imported: 0 (empty spatial dataframe)")
  } else {
    print(paste("Number of new records in dataframe to be imported:", nrow(DF_Output)))
  }
  
  return(DF_Output) 
    
}