#' Select specific question columns of run characterization table.
#'
#' Select specific question columns of run characterization table.
#' @param RunCharAssessFormatted Formated data frame.
#' @param QuestCode Code for question.
#' @return Formatted dataframe.
#' @examples 
#' require(SarpGPSTools)
#' require(SarpGPSToolsPrivate)
#' 
#' Operation <- "NEH"
#' RunCharAssess <- getRecordsFromQuery(Operation, "SELECT * FROM runchar.assessments")
#'
#' RunCharAssessFormatted <- formatRunCharAssessmentDF(Operation, RunCharAssess)
#' 
#' ## GET QUESTION DEFINITION TABLE FOR QUESTION CODES
#' QuestDef <- getRecordsFromQuery(Operation, "SELECT * FROM runchar.questions")
#' 
#' QuestCode <- "familiarity"
#' RunCharAssessQuestion <- selectRunCharAssessQuestion(RunCharAssessFormatted, QuestCode, Operation=Operation)
#' @export

selectRunCharAssessQuestion <- function(RunCharAssessFormatted, QuestCode, Operation, ElevLevels=c("all", "alp", "tl", "btl")){
  
  QuestDef <- getRecordsFromQuery(Operation, "SELECT * FROM runchar.questions")
  LineLevels <- convertArrayFromSQL(QuestDef[QuestDef$code==QuestCode,]$linelevels,Numeric=F)
  ElevLevels <- convertArrayFromSQL(QuestDef[QuestDef$code==QuestCode,]$elevlevels,Numeric=F)
  
  QuestCol <- getRunCharQuestColNames(QuestCode=QuestCode, Operation=Operation, AssessTblFormatted = T, ElevLevels=ElevLevels, LineLevels=LineLevels )

  IDCol <- c("uuid", "loccatskiruns_uuid", "loccatskilines_uuid")
  output <- RunCharAssessFormatted[, c(IDCol, QuestCol)]
  
  ## RETURN SELECTION
  return(output)
  
}## END FUNCTION