#' Sends notification email.
#'
#' Sends notification email with sarpgps_at_sfu.ca.
#' @param EmailAddressees Array of email addressees that should be notified. 
#' @param Subject Subject line
#' @param Body Body of email
#' 
#' @examples 
#' require(SarpGPSToolsPrivate)
#' require(SarpGPSTools)
#' 
#' sendNotificationEmail("pascal_haegeli@sfu.ca", Subject = "Test", Body = "This is a test email")
#' 
#' @export

sendNotificationEmail <- function (EmailAddressees, Subject, Body=Subject) {
  
  for (Index_Addressee in 1:length(EmailAddressees)) {
    
    mailR::send.mail(from = 'sarpgps@sfu.ca',
                     to = EmailAddressees[Index_Addressee],
                     subject = Subject,
                     body = Body,
                     smtp = SARPSmtpSettings, 
                     authenticate = TRUE,
                     send = TRUE)
  }
  
}