#' Send SQL query to PostgreSQL/PostGIS GPS database.
#'
#' Send SQL query that does not produce any result (e.g., delete query, insert query, ...) to PostgreSQL/PostGIS GPS database. IMPORTANT: Only use for single queries or short loops. Long loops are much faster if the Db connection is established once and all records are submitted together. See writeDFToGPSDB for example.
#' @param Operation Name of operation for accessing correct database.
#' @param Query SQL query.
#' @param DBType Type of database to send the query to. Can be 'Main' (default) or 'NodeJS' for database that feeds online viewer
#' @param Verbose Switch for printing SQL query. Default value is FALSE.
#' @param SuppressPostgreSQLWarnings Switch for turning warnings off. Default value is TRUE.
#' @param MaxNumTries Number of maximum tries that are attempted. Default value is 10.
#' @export

sendQueryToGPSDB <- function(Operation, Query, DBType="Main", Verbose=F, SuppressPostgreSQLWarnings=T, MaxNumTries=10) {

  if(Verbose) {cat(Query, "\n")}

  if (SuppressPostgreSQLWarnings) {options(warn=-1)}

  # DBCon <- connectToGPSDB(Operation, ReadOnly=F, DBType=DBType)
  DBCon <- tryMultipleTimes(connectToGPSDB(Operation, ReadOnly=F, DBType=DBType), MaxNumTries=MaxNumTries)

  Result <- dbSendQuery(DBCon, Query)

  dbDisconnect(DBCon)
  rm(DBCon)

  if (SuppressPostgreSQLWarnings) {options(warn=0)}

}
