#' Send SQL query to MySQL terrain survey database.
#'
#' Send SQL query that does not produce any result (e.g., delete query, insert query, ...) to MySQL terrain database. IMPORTANT: Only use for single queries or short loops. Long loops are much faster if the Db connection is established once and all records are submitted together. See writeDFToGPSDB for example.
#' @param Query SQL query.
#' @param Verbose Switch for printing SQL query. Default value is FALSE.
#' @param SuppressMySQLWarnings Switch for turning warnings off. Default value is TRUE.
#' @param MaxNumTries Number of maximum tries that are attempted. Default value is 10.
#' @export

sendQueryToTerrainSurveyDB <- function(Query, Verbose=F, SuppressMySQLWarnings=T, MaxNumTries=10) {

  if(Verbose) {cat(Query, "\n")}

  if (SuppressMySQLWarnings) {options(warn=-1)}

  DBCon <- tryMultipleTimes(connectToTerrainSurveyDB(), MaxNumTries=MaxNumTries)
  Result <- dbSendQuery(DBCon, Query)

  dbDisconnect(DBCon)
  rm(DBCon)

  if (SuppressMySQLWarnings) {options(warn=0)}

}
