#' Updates the link between skiruns, skilines and the zones they are in.
#'
#' Updates the link between skiruns, skilines and the zones they are in. This information is required for the runlists.
#' @param Operation Name of operation.
#' @param DBType Name of database. Nedds to be either 'Main' (default) of 'NodeJS'.
#'
#' @export

updateLoccatSkiRunsSkiLines2ZoneLinks <- function(Operation, DBType="Main") {
  
  LocCat <- getLocCatlog(Operation, DBType = DBType,  AsCentroidsSkiRuns = T, AsCentroidsSkiLines = T)
  Zones <- LocCat$Zones
  
  if(!is.null(LocCat$SkiRuns)>0) {
    
    SkiRuns <- LocCat$SkiRuns[is.na(LocCat$SkiRuns@data$loccatzone_uuid),]
    
    if(nrow(SkiRuns)>0) {
      
      print(paste0("Processing ", nrow(SkiRuns), " ski runs ...."))
    
      for (IndexZ in 1:nrow(Zones)) {
        InZone <- isPointInSPDFPolygons(SkiRuns@coords[,1], SkiRuns@coords[,2], Zones[IndexZ,])
        SkiRuns@data$loccatzone_uuid[which(InZone==1)] <- Zones@data$uuid[IndexZ]
      }
      rm(InZone, IndexZ)
      
      SkiRunsUpdateDF <- SkiRuns@data[!is.na(SkiRuns@data$loccatzone_uuid),c("uuid", "loccatzone_uuid")]
      if (nrow(SkiRunsUpdateDF)>0) {
        updateTblInGPSDB(SkiRunsUpdateDF, Operation, "loccat", "skiruns", DBType=DBType, WriteToHistTbl=F, ShowCounter=0)
      } else {
        message("Centroids of remaining ski runs are all out outside of zones!")
      }
      
    } else {
      message("No ski runs needed to be updated!")
    }
    
  } else {
    message(paste0("No ski runs available for ", Operation, "!"))
  }
  
  if(!is.null(LocCat$SkiLines)) {
    
    SkiLines <- LocCat$SkiLines[is.na(LocCat$SkiLines@data$loccatzone_uuid),]
  
    if(nrow(SkiLines)>0) {
      
      print(paste0("Processing ", nrow(SkiLines), " ski lines ...."))
      
      for (IndexZ in 1:nrow(Zones)) {
        InZone <- isPointInSPDFPolygons(SkiLines@coords[,1], SkiLines@coords[,2], Zones[IndexZ,])
        SkiLines@data$loccatzone_uuid[which(InZone==1)] <- Zones@data$uuid[IndexZ]
      }
      rm(InZone, IndexZ)
      
      SkiLinesUpdateDF <- SkiLines@data[!is.na(SkiLines@data$loccatzone_uuid),c("uuid", "loccatzone_uuid")]
      if (nrow(SkiLinesUpdateDF)) {
        updateTblInGPSDB(SkiLinesUpdateDF, Operation, "loccat", "skilines", DBType=DBType, WriteToHistTbl=F, ShowCounter=0)
      } else {
        message("Centroids of remaining ski lines are all out outside of zones!")
      }
      
    } else {
      message("No ski lines needed to be updated!")
    }
    
  } else {
    message(paste0("No ski lines available for ", Operation, "!"))
  }

}  