#' Update NodeJS database with latest information for multiple operations.
#'
#' Update NodeJS database with latest information for multiple Operations. 
#' @param Operations Array with names of operations
#' @param RunlistDateStart Starting date for specifying the range of Runlist data that should be transferred.
#' @param RunlistDateEnd End date for specifying the range of Runlist data that should be transferred.
#' @export

updateNodeJSMultiple <- function(Operations=c("CMHGL", "CMHRE", "MPS", "MWHS", "NEH", "STHS", "WHS"), RunlistDateStart=NA, RunlistDateEnd=RunlistDateStart) {

  for (Index in 1:length(Operations)) {
    print("*************")
    print(paste("***", Operations[Index],"***"))
    print("*************")
    updateNodeJS(Operations[Index], RunlistDateStart=RunlistDateStart, RunlistDateEnd=RunlistDateEnd)
    print("")
  }
  
  print("Summarizing content of NodeJS DB Server")
  print("***************************************")
  print(countGPSRecordsMultiple(DBType="NodeJS"))
  
}