#' Updates reference for raster and array table for extracted values in PostgreSQL/PostGIS GPS DB
#'
#' Updates reference for raster and array table for extracted values in PostgreSQL/PostGIS GPS DB.
#' @param Operation Name of Operation. Used for accessing PostgreSQL database.
#' @param RasterName Current name of raster.
#' @param New_RasterName Optional new name of raster.
#' @param New_FileName Optional new file name of raster.
#' @param New_Subfolder Optional new subfolder of raster.
#' @param New_GisArrayNameExtension Optional new extension for array table.
#' @param Verbose Switch for printing SQL query. Default value is FALSE.
#' @param SuppressPostgreSQLWarnings Switch for turning warnings off. Default value is TRUE.
#'
#' @export

updateRasterRefAndArrayTbl <- function(Operation, RasterName, New_RasterName=NA, New_FileName=NA, New_Subfolder=NA, New_GisArrayNameExtension=NA, Verbose=F, SuppressPostgreSQLWarnings=T) {

  ## Defaults
  DBType <- "Main"
  
  if (!is.na(New_FileName)) {
    Query <- paste0("UPDATE misc.rasters SET file_name='", New_FileName, "' WHERE name='", RasterName, "'")
    sendQueryToGPSDB(Operation, Query, DBType=DBType, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)
  }

  if (!is.na(New_Subfolder)) {
    Query <- paste0("UPDATE misc.rasters SET subfolder='", New_Subfolder, "' WHERE name='", RasterName, "'")
    sendQueryToGPSDB(Operation, Query, DBType=DBType, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)
  }

  if (!is.na(New_GisArrayNameExtension)) {
    Tblname_Prefix <- "gpsruns_array_"
    OldTblName <- paste0(Tblname_Prefix, getRecordsFromQuery(Operation, paste0("SELECT gis_array_name_ext FROM misc.rasters WHERE name='", RasterName, "'")))
    NewTblName <- paste0(Tblname_Prefix, tolower(New_GisArrayNameExtension))

    Query <- paste0("UPDATE misc.rasters SET gis_array_name_ext='", tolower(New_GisArrayNameExtension), "' WHERE name='", RasterName, "'")
    sendQueryToGPSDB(Operation, Query, DBType=DBType, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)
    Query <- paste0("ALTER TABLE gis.", OldTblName, " RENAME TO ", NewTblName)
    sendQueryToGPSDB(Operation, Query, DBType=DBType, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)
  }


  if (!is.na(New_RasterName)) {
    Query <- paste0("UPDATE misc.rasters SET name='", New_RasterName, "' WHERE name='", RasterName, "'")
    sendQueryToGPSDB(Operation, Query, DBType=DBType, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)
  }

}
