#' Retrieve location order from Snowbase and write into PostgreSQL/PostGIS GPS database.
#'
#' Retrieve location order from Snowbase and write into PostgreSQL/PostGIS GPS database.
#' @param Operation Name of operation
#' @param DBType Optional variable for specifying which database type the location catalog should be imported. Values can be 'Main' (default) or 'NodeJS
#' @param Overwrite Boolean flag for whether the entire avobs table should be overwritten (i.e., all records deleted first). Default is F.

#' @export

updateSnowbaseLocOrder <- function(Operation, DBType="Main", Verbose=F, SuppressPostgreSQLWarnings=T) {
  
  ## Retrieve information from InfoEx
  print("Retrieving records from Snowbase")
  LocOrder <- SarpCMHSnowbase::getSnowbaseLocOrder(Operation, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)
  
  ## Processing
  if(nrow(LocOrder)> 0) {
    
    print(paste0("Number of loc order records retrieved from Snowbase: ", nrow(LocOrder)))
    
    ## Processing Zones
    print("Processing zones for import into GPS database ...")
    Query <- "SELECT uuid, external_id FROM loccat.zones"
    ZonesInDB <- getRecordsFromQuery(Operation, Query)
    
    ZoneOrder <- LocOrder[LocOrder$Geo_Id %in% ZonesInDB$external_id,]
    
    names(ZoneOrder) <- c("external_id", "order")
    
    ZonesInDB <- merge(ZonesInDB, ZoneOrder)
    ZonesInDB <- deleteDFColumnsByName(ZonesInDB, "external_id")
    
    if (nrow(ZonesInDB)>0) { 
      updateTblInGPSDB(ZonesInDB, Operation, "loccat", "zones", WriteToHistTbl = F, ShowCounter = 0)
    }
    
    ## Processing Zones
    print("Processing ski runs for import into GPS database ...")
    Query <- "SELECT uuid, external_id FROM loccat.skiruns"
    SkiRunsInDB <- getRecordsFromQuery(Operation, Query)
    
    SkiRunsOrder <- LocOrder[LocOrder$Geo_Id %in% SkiRunsInDB$external_id,]
    
    names(SkiRunsOrder) <- c("external_id", "loccatzone_order")
    
    SkiRunsInDB <- merge(SkiRunsInDB, SkiRunsOrder)
    SkiRunsInDB <- deleteDFColumnsByName(SkiRunsInDB, "external_id")
    
    if (nrow(SkiRunsInDB)>0) { 
      updateTblInGPSDB(SkiRunsInDB, Operation, "loccat", "skiruns", WriteToHistTbl = F, ShowCounter = 0)
    }
    
  } else {
    
    warning("No location order records to import!", immediate. = T)
    
  }
  
}  