#' Write spatial dataframe to CSV file
#'
#' Writes entire content of spatial dataframe to CSV file. Geometry it converted into well-known-text (WKT).
#' @param SPDF Spatial dataframe
#' @param FileName Full path of file name
#' @param GeomCol Name of geometry column in csv file
#' @param SRID Numeric reference to coordinate system for geospatial information
#' @param na Specifies how NA are handled
#' @export

writeSPDFToCSV <- function(SPDF, FileName, GeomCol="geomWKT", SRID=4617, na=NA) {

  ## Extract pure DF
  DF <- SPDF@data
  ColNames <- colnames(DF)

  ## Create geometry column with specified name (requires rgeos)
  DF$geom <- rgeos::writeWKT(SPDF, byid = T)
  # Does not work for multi* geometries --> creates array instead of single string

  ## Update name of geometry column
  colnames(DF) <- c(ColNames, GeomCol)

  ## Write CSV file
  write.csv(DF, file=FileName, na = na)
}
