% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addRatingToRasterValueDf.R
\name{addRatingToRasterValueDf}
\alias{addRatingToRasterValueDf}
\title{Adds PM rating column to raster value dataframe.}
\usage{
addRatingToRasterValueDf(Operation, RasterValueDf, DBType = "Main",
  Type = "Hzd", Time = "PM", ColLabel = "rating")
}
\arguments{
\item{Operation}{Name of Operation. Used for accessing PostgreSQL database.}

\item{RasterValueDf}{Raster value dataframe created with the getRasterValueDfFromRunUUID function. Dataframe needs to have column 'elevband'.}

\item{DBType}{Parameter for specifying database type. Value can be 'Main' (default), 'NodeJS' or 'old'.}

\item{Type}{Type of rating. Needs to be either 'Hzd' (default) or 'Stb'. Not all operations support all ratings.}

\item{Time}{Time of rating. Needs to be either 'PM' (default) or 'AM'.}

\item{ColLabel}{label fo rating column.}
}
\value{
Original RastervalueDf data frame with PM rating attached
}
\description{
Adds PM rating column to raster value dataframe created with the getRasterValueDfFromRunUUID function.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Oper <- "CMHGL"

## Retrieve UUIDs of GPS runs for a time period
GPSRunsUUID <- getRunUUIDsFromTrackerUnitAndDate(Operation = Oper, DateStart="2018-02-01", DateEnd = "2018-02-10")

## Getting raster values for these GPS runs
RasterValues <- getRasterValueDfFromRunUUID(Operation = Oper, RunUUIDList = GPSRunsUUID) 

## Adding the PM hazard ratings to raster values
RasterValues <- addRatingToRasterValueDf(Operation = Oper, RasterValueDf = RasterValues)

}
\seealso{
\code{\link{getRasterValueDfFromRunUUID}}
}
