% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkRunCharForMissingData.R
\name{checkRunCharForMissingData}
\alias{checkRunCharForMissingData}
\title{Check run characterization answers for completeness.}
\usage{
checkRunCharForMissingData(RunCharAssess, LinesExist, Operation)
}
\arguments{
\item{RunCharAssess}{Data frame from runchar.assessments.}

\item{LinesExist}{Data frame with existing lines per on ski run.}

\item{Operation}{Operation.}
}
\value{
data frame with evaluation.
}
\description{
Check run characterization answers for completeness.
}
\examples{
## MAKE CONTROL DATA FRAME WITH EXISTING SKI LINES ON A SKI RUN (yes/NA)
Operation <- "NEH"
RunListForm <- getRunListForm(Operation)
ifelse(Operation=="NEH", RunListForm <- RunListForm[RunListForm$zone_name=="Promised Land",], RunListForm)
TblSkiRuns  <- getRecordsFromQuery(Operation, "SELECT uuid, terrain_class1, terrain_class2, terrain_class3 FROM loccat.skiruns")
TblSkiLines <- getRecordsFromQuery(Operation, "SELECT uuid, terrain_class1, terrain_class2, terrain_class3  FROM loccat.skilines")
a <- merge(RunListForm, TblSkiRuns, by.x="loc_uuid", by.y="uuid")
b <- merge(RunListForm, TblSkiLines, by.x="loc_uuid", by.y="uuid")
DF <- rbind(a,b)
DF <- DF[order(DF$loc_order),]
rm(a,b,TblSkiRuns,TblSkiLines)
DF$line_c <- DF$terrain_class1
DF$line_t <- DF$terrain_class2
DF$line_a <- DF$terrain_class3

DF <- DF[,c("loc_uuid", "line_c", "line_t", "line_a")]

## RETREIVE FROM DATABASE
RunCharAssess <- getRecordsFromUUID(Operation, "runchar", "assessments")

## RETREIVE FROM DATABASE
QC <- checkRunCharForMissingData(RunCharAssess=RunCharAssess, LinesExist=DF, Operation=Operation)

}
