% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkRunCharMCEnumerations.R
\name{checkRunCharMCEnumerations}
\alias{checkRunCharMCEnumerations}
\title{Lists and counts the used enumerations in the multiple choice questions for the run characterization.}
\usage{
checkRunCharMCEnumerations(Operation, QuestionCode)
}
\arguments{
\item{Operation}{Name of Operation. Used for accessing PostgreSQL database.}

\item{QuestionCode}{Code for question from the runchar.questions table}
}
\value{
DF with enumerations found in relevation fields in the runchar.assessments table.
}
\description{
Lists and counts the used enumerations in the multiple choice questions for the run characterization. This is useful to spot typos and new enumerations since the enumerations cannot be enforced in the multiple choice questions.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "CMHGL"
QuestionCode <- "ski_spec"
checkRunCharMCEnumerations(Operation, QuestionCode)

}
