% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertAvProbLabelFromInfoEx.R
\name{convertAvProbLabelFromInfoEx}
\alias{convertAvProbLabelFromInfoEx}
\title{Converts avalanche problem labels from Infoex into standard labels}
\usage{
convertAvProbLabelFromInfoEx(AvProbInfoEx)
}
\arguments{
\item{AvProbInfoEx}{Avalanche Problem label from InfoEx}
}
\value{
Standard avalanche problem label
}
\description{
Converts avalanche problem labels from Infoex into standard labels
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "NEH"
Query <- "SELECT Count(infoex.hzdassess_avprob.uuid), infoex.hzdassess_avprob.character FROM infoex.hzdassess_avprob GROUP BY infoex.hzdassess_avprob.character"

AvProblemCounts <- getRecordsFromQuery(Operation, Query)
AvProblemCounts$AvProbLabel <- convertAvProbLabelFromInfoEx(AvProblemCounts$character)
}
