% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertRunCharRaw2Long.R
\name{convertRunCharRaw2Long}
\alias{convertRunCharRaw2Long}
\title{Converts original run characterization assessments into three analysis table.}
\usage{
convertRunCharRaw2Long(Survey, addUserInfo = TRUE)
}
\arguments{
\item{Survey}{Survey object created with getRunCharAssessmentsSurvey() function}

\item{addUserInfo}{Switch whether user info from the UserInfo table should be added. Default is TRUE.}
}
\value{
List of three dataframes. One for each aggregation level (run, line and elevation band).
}
\description{
Converts original run characterization assessments into three analysis table, one for each aggregation level: run, line and elevation band.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Survey <- getRunCharAssessmentsSurvey("NEH")
AnalysisTbls <- convertRunCharRaw2Long(Survey)


}
