% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createOperUserInTerrainSurveyDB.R
\name{createOperUserInTerrainSurveyDB}
\alias{createOperUserInTerrainSurveyDB}
\title{Creates operation and user account in terrain survey.}
\usage{
createOperUserInTerrainSurveyDB(OpName, OpAbbrev = "", UserName,
  UserEmail, UserPassword, Line1Label = "Line 1",
  Line2Label = "Line 2", Line3Label = "Line 3",
  SunCrustDate = "April 1")
}
\arguments{
\item{OpName}{Name of operation}

\item{OpAbbrev}{Abbreviation of operation (default is empty string)}

\item{UserName}{Name of user}

\item{UserEmail}{Email address of user}

\item{UserPassword}{Password for user}

\item{Line1Label}{General label for Line 1 (default is Line 1)}

\item{Line2Label}{General label for Line 2 (default is Line 2)}

\item{Line3Label}{General label for Line 3 (default is Line 3)}

\item{SunCrustDate}{Default date for suncrust question (default is April 1)}
}
\description{
Creates operation and user account in terrain survey.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

## Creating operation first first user
createOperUserInTerrainSurveyDB(OpName="Test", UserName = "Test", UserEmail = "test@test.com", UserPassword = "test")

## Adding additional user to operation
createOperUserInTerrainSurveyDB(OpName="Test", UserName = "Test", UserEmail = "test2@test.com", UserPassword = "test")
}
