% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createRasterRefAndArrayTbl.R
\name{createRasterRefAndArrayTbl}
\alias{createRasterRefAndArrayTbl}
\title{Creates new reference for raster and array table for extracted values in DB}
\usage{
createRasterRefAndArrayTbl(Operation, RasterName, FileName, Subfolder,
  GisArrayTblNameExt = tolower(RasterName), ValueType = "Integer",
  DBType = "Main", TimeDiffToServer = 0, Verbose = F,
  SuppressPostgreSQLWarnings = T)
}
\arguments{
\item{Operation}{Name of Operation. Used for accessing PostgreSQL database.}

\item{RasterName}{Name of raster.}

\item{FileName}{File name of raster file. Typically a tif file.}

\item{Subfolder}{Name of the local subfolder there the tif file is located. If there are nested subfolder, please not that the slashes need to be FOUR (4!) backslashes.}

\item{GisArrayTblNameExt}{Name extension for table in gis schema. Default value is RasterName in all lowercase.}

\item{ValueType}{Numeric type for value array. Needs to be 'integer' or 'real'. Default value is 'integer'.}

\item{DBType}{Parameter for specifying which database type to create the raster reference and array table into. Values can be 'Main' (default), 'NodeJS' and 'Old'.}

\item{TimeDiffToServer}{Time difference to database server in hours. Default value is 0 hrs.}

\item{Verbose}{Switch for printing SQL query. Default value is FALSE.}

\item{SuppressPostgreSQLWarnings}{Switch for turning warnings off. Default value is TRUE.}
}
\description{
Creates new reference for raster and array table for extracted values in DB.
}
