% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createRunViewFromUUID.R
\name{createRunViewFromUUID}
\alias{createRunViewFromUUID}
\title{Creates view of GPS runs from list of UUID.}
\usage{
createRunViewFromUUID(Operation, User, Schema, ViewName, ViewDescription,
  UUID, DBType = "Main", OnlyQCRuns = T, Overwrite = F,
  Verbose = F, SuppressPostgreSQLWarnings = T)
}
\arguments{
\item{Operation}{Name of operation.}

\item{User}{Name of user.}

\item{Schema}{Name of schema where view should be created.}

\item{ViewName}{Name of view to be created.}

\item{ViewDescription}{Description for view to be created.}

\item{UUID}{Single UUID or array of UUIDs.}

\item{DBType}{Parameter for specifying which database type tp create the view in. Values can be 'Main' (default), 'NodeJS' or 'Old'.}

\item{OnlyQCRuns}{Switch to specify whether to process only runs that are quality controlled (default) or all runs. Default value is TRUE.}

\item{Overwrite}{Switch for specifying whether an existing view of the same name should be overwritten.}

\item{Verbose}{Switch for printing of query}

\item{SuppressPostgreSQLWarnings}{Switch for suppressing warning messages from postgresqlExecStatement. Turn on for debugging!}
}
\description{
Creates view of GPS runs from list of UUID.
}
