% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutGPSRunsIntoElevBandSegments.R
\name{cutGPSRunsIntoElevBandSegments}
\alias{cutGPSRunsIntoElevBandSegments}
\title{Cut GPSRuns into elevation band segments}
\usage{
cutGPSRunsIntoElevBandSegments(Operation, User, DBType = "Main",
  Method = "simple", Buffer = 20, OnlyQCRuns = T, DateStart = NA,
  DateEnd = DateStart, Overwrite = F, Test = F,
  TimeDiffToDBServer = 7, UserConfirm = T, Verbose = F,
  SuppressPostgreSQLWarnings = T)
}
\arguments{
\item{Operation}{Name of operation}

\item{User}{Name of user. Required for local root folder for location of raster.}

\item{DBType}{Parameter to specify which database type the elevant band segements the runs should be written to. The value can be 'Main' (default), 'NodeJS' or 'Old'.}

\item{Method}{Method for extraction of raster values. Must be 'simple' or 'bilinear'. See help for raster::extract for more detail.}

\item{Buffer}{size of buffer around GPS ski run in metres. Default value is 20 m. See help for raster::extract for more detail.}

\item{OnlyQCRuns}{Switch to specify whether to process only runs that are quality controlled (default) or all runs. Default value is TRUE}

\item{DateStart}{Start date if time period is specified in format 'YYYY-MM-DD'. Default value is NA.}

\item{DateEnd}{End date if time period is specified in format 'YYYY-MM-DD'. Default value is DateStart.}

\item{Overwrite}{Switch to specify whether to erase all records from the table before (re-) processing the runs. Default value id FALSE.}

\item{Test}{Only the first 10 runs are processed in Test mode. Default value is FALSE.}

\item{TimeDiffToDBServer}{Time difference to database server. Default value is 7 hrs (PST -> GMT)}

\item{UserConfirm}{Flag whether the user needs to actively confirm deletion. True by default.}

\item{Verbose}{Switch for printing of query. Default value is FALSE.}

\item{SuppressPostgreSQLWarnings}{Switch for turning warnings off. Default value is TRUE.}
}
\description{
Cuts GPS ski runs into elevation band segments and stores them in PostgreSQL/PostGIS GPS database. Only processes ski run tracks that have not been processed yet.
}
