% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteTrackRecords.R
\name{deleteTrackRecords}
\alias{deleteTrackRecords}
\title{Deletes track record including all of the related child records in PostgreSQL/PostGIS GPS database.}
\usage{
deleteTrackRecords(Operation, Track_UUID = NA, Track_RawFile = NA,
  DBType = "Main", UserConfirm = T, Verbose = F,
  SuppressPostgreSQLWarnings = T)
}
\arguments{
\item{Operation}{Name of operation.}

\item{Track_UUID}{UUID of track to be deleted.}

\item{Track_RawFile}{Name of original data file of the GPS track.}

\item{DBType}{Parameter for specifying for which database type to delete the track records from. Values can be 'Main' (default), 'NodeJS' or 'Old'.}

\item{UserConfirm}{Flag whether the user needs to actively confirm deletion. Default value is TRUE.}

\item{Verbose}{Switch for printing of query. Default value is FALSE.}

\item{SuppressPostgreSQLWarnings}{Switch for turning warnings off. Default value is TRUE.}
}
\description{
Deletes track record including all of the related child records in PostgreSQL/PostGIS GPS database. Returns dataframe with number of records deleted.
}
