% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteTrackdayRecords.R
\name{deleteTrackdayRecords}
\alias{deleteTrackdayRecords}
\title{Deletes tracksday record including all of the related child records in PostgreSQL/PostGIS GPS database}
\usage{
deleteTrackdayRecords(Operation, TrackDay_UUID = NA,
  TrackDay_Date = NA, TrackDay_Unit = NA, DBType = "Main",
  UserConfirm = T, Verbose = F, SuppressPostgreSQLWarnings = T)
}
\arguments{
\item{Operation}{Name of operation.}

\item{TrackDay_UUID}{UUID of trackday to be deleted}

\item{TrackDay_Date}{Date of trackday to be deleted}

\item{TrackDay_Unit}{Unit of trackday to be deleted}

\item{DBType}{Parameter for specifying for which database type to delete the track records from. Values can be 'Main' (default), 'NodeJS' or 'Old'.}

\item{UserConfirm}{Flag whether the user needs to actively confirm deletion. True by default.}

\item{Verbose}{Switch for printing of query. Default value is FALSE.}

\item{SuppressPostgreSQLWarnings}{Switch for turning warnings off Default value is TRUE.}
}
\description{
Deletes tracksday record including all of the related child records in PostgreSQL/PostGIS GPS database. Returns dataframe with number of records deleted. Input parameter needs to be either be a uuid or a date and unit.
}
