% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractRasterValuesAlongGPSRuns.R
\name{extractRasterValuesAlongGPSRuns}
\alias{extractRasterValuesAlongGPSRuns}
\title{Extract values from raster along ski runs}
\usage{
extractRasterValuesAlongGPSRuns(Operation, User, RasterNames,
  Method = "simple", Buffer = 20, DecimalDigits = 0,
  OnlyQCRuns = T, Overwrite = F, Test = F, TimeDiffToDBServer = 7,
  UserConfirm = T, DBType = "Main", Verbose = F,
  SuppressPostgreSQLWarnings = T)
}
\arguments{
\item{Operation}{Name of operation}

\item{User}{Name of user. Required for local root folder for location of raster.}

\item{RasterNames}{Name of raster(s) to be processed. Can be single string or array of strings.}

\item{Method}{Method for extraction of raster values. Must be 'simple' or 'bilinear'. See help for raster::extract for more detail.}

\item{Buffer}{size of buffer around GPS ski run in metres. Default value is 20 m. See help for raster::extract for more detail.}

\item{DecimalDigits}{Decimal digits for extracted values. Default value is 0 (zero). Can be single number of array of numbers. If an array, it needs to be os same size as RasterNames.}

\item{OnlyQCRuns}{Switch to specify whether to process only runs that are quality controlled (default) or all runs. Default value is TRUE}

\item{Overwrite}{Switch to specify whether to erase all records from the table before (re-) processing the runs. Default value id FALSE.}

\item{Test}{Only the first 10 runs are processed in Test mode. Default value is FALSE.}

\item{TimeDiffToDBServer}{Time difference to database server. Default value is 7 hrs (PST -> GMT)}

\item{UserConfirm}{Flag whether the user needs to actively confirm deletion. True by default.}

\item{DBType}{Parameter for specifying which database the extracted values should be written to. Values can be 'Main' (default), 'NodeJS' or 'Old'.}

\item{Verbose}{Switch for printing of query. Default value is FALSE.}

\item{SuppressPostgreSQLWarnings}{Switch for turning warnings off. Default value is TRUE.}
}
\description{
Extract values from raster within a given buffer along GPS ski runs and stores them in PostgreSQL/PostGIS GPS database.
}
