% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterRasterValueDfByDailyQuantiles.R
\name{filterRasterValueDfByDailyQuantiles}
\alias{filterRasterValueDfByDailyQuantiles}
\title{Filters raster value dataframe by daily quantile range.}
\usage{
filterRasterValueDfByDailyQuantiles(RasterValueDf, ColName, QuantileBottom,
  QuantileTop = 1)
}
\arguments{
\item{RasterValueDf}{The raster value dataframe (class RasterValueDf) created with the getRasterValueDfFromRunUUID function.}

\item{ColName}{Name of the column over which the filter should be applied.}

\item{QuantileBottom}{Value between 0 and 1 to specify the bottom quantile boundary for the extracted data. A value of 0.8 extracts the records with the top 20 percent incline values for each day.}

\item{QuantileTop}{Value between 0 and 1 to specify the top quantile boundary for the extracted data. Default value is 1.}
}
\value{
List with two data frames: 1) DataFrame: filtered dataframe; 2) DayStats: Daily processing statistics
}
\description{
Filters raster value dataframe by daily quantile range. The raster value dataframe needs to be created with the getRasterValueDfFromRunUUID function.
}
\seealso{
\code{\link{getRasterValueDfFromRunUUID}}
}
