% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatRunCharAssessmentDF.R
\name{formatRunCharAssessmentDF}
\alias{formatRunCharAssessmentDF}
\title{Formats Run character assessment dataframe for analysis}
\usage{
formatRunCharAssessmentDF(Operation, AssessmentDF, Progress = TRUE,
  Verbose = FALSE)
}
\arguments{
\item{Operation}{Name of operation}

\item{AssessmentDF}{Run character assessment dataframe}

\item{Progress}{Switch for printing progess (default = TRUE)}

\item{Verbose}{Switch for printing queries (default = FALSE)}
}
\value{
Formatted dataframe.
}
\description{
Formats Run character assessment dataframe for analysis
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "NEH"
RunCharAssess <- getRecordsFromQuery(Operation, "SELECT * FROM runchar.assessments")

RunCharAssessFormatted <- formatRunCharAssessmentDF(Operation, RunCharAssess)
}
