% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getArrayTblFromUUIDLoccatSkiruns.R
\name{getArrayTblFromUUIDLoccatSkiruns}
\alias{getArrayTblFromUUIDLoccatSkiruns}
\title{Gets array table for loccation catalog skiruns from PostgreSQL/PostGIS GPS database in useable format for R.}
\usage{
getArrayTblFromUUIDLoccatSkiruns(Operation, RasterName, UUID = NA,
  DBType = "Main", Verbose = F, SuppressPostgreSQLWarnings = T)
}
\arguments{
\item{Operation}{Name of Operation}

\item{RasterName}{Name of raster of array table}

\item{UUID}{Single or array of UUIDs. Default value is NA, which returns entire table.}

\item{DBType}{Optional parameter to specify which database type to get the array table from. Values can be 'Main' (default) or 'NodeJS'.}

\item{Verbose}{Switch for printing of query}

\item{SuppressPostgreSQLWarnings}{Switch for suppressing warning messages from postgresqlExecStatement. Turn on for debugging!}
}
\value{
Array Table as dataframe with value array as a vector.
}
\description{
Gets array table for loccation catalog skiruns from PostgreSQL/PostGIS GPS database in useable format for R. IMPORTANT: To assess array values of individual row use 'ArrayTbl[Index][[1]]' command.
}
