% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDEM.R
\name{getDEM}
\alias{getDEM}
\title{Gets DEM for Operation}
\usage{
getDEM(Oper, highres = F, localpath = NA,
  baseurl = "http://data.avalancheresearch.ca/")
}
\arguments{
\item{Oper}{Abbreviation of operation}

\item{localpath}{Local path for source of DEM tif file. Default is NA, which uses working directory.}

\item{baseurl}{URL for remote source of DEM files. Default is http://data.avalancheresearch.ca/.}

\item{higres}{Switch for high-res DEM. Default is FALSE}
}
\description{
Gets low-res (7.5 arc sec) or high-res (20m) DEM for operation either from local path or working directory (default).
If file does not exist locally, it is downloaded from http://data.avalancheresearch.ca.
}
\examples{
require(SarpGPSTools)

Oper <- "CMHGL"

## Low resolution
DEM <- getDEM(Oper)
plot(DEM)

## High resolution stored in working directory
DEM <- getDEM(Oper, highres=T)
plot(DEM)

## High resolution stored in local directory
DEM <- getDEM(Oper, highres=T, localpath="C:/Temp/")
plot(DEM)

}
