% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDistanceInTerrainClassesFromGPSRunsUUID.R
\name{getDistanceInTerrainClassesFromGPSRunsUUID}
\alias{getDistanceInTerrainClassesFromGPSRunsUUID}
\title{Extracts distance skied in three NEH terrain classes from GPS runs.}
\usage{
getDistanceInTerrainClassesFromGPSRunsUUID(Operation, GPSRuns_UUID,
  ShowCounter = 1, Verbose = F)
}
\arguments{
\item{Operation}{Name of operation.}

\item{ShowCounter}{Numeric value that specifies whether counter for queries should be shown (>0) and at what interval}

\item{Verbose}{Switch for printing of query}

\item{GPSRunsUUIDs}{Array of uuids of gps runs}
}
\value{
Dataframe with distances in metre.
}
\description{
Extracts distance skied in three NEH terrain classes from GPS runs.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Oper <- "NEH"
RunName <- c("White Rabbit", "Jabber Walky")

## Get  location catalog
LocCat <- getLocCatlog(Oper)

## Get all GPS runs from these two runs
GPSRuns_UUID <- getGPSRunsUUIDsFromLoccatSkiRunLineUUIDsNames(Oper, Names=RunName)

## Calculates skied distance in difference terrain classes
DistInTerrainClasses <- getDistanceInTerrainClassesFromGPSRunsUUID(Oper, GPSRuns_UUID)

## Base map
plot(LocCat, ZoomArea=RunName, ShowSkiRunSegments=T, main=paste0("Base map for ", paste(RunName, collapse = ", ")))

## Runs that did not include any black terrain
GPSRunsNoBlack_UUID <- as.character(DistInTerrainClasses$gpsruns_uuid[DistInTerrainClasses$black==0])
GPSRunsNoBlack <- getRunsObjectFromUUIDs(Oper, GPSRunsNoBlack_UUID, WithObsPoints = F, WithPausePoints = F)

plot(LocCat, ZoomArea=RunName, ShowSkiRunSegments=T, main="Only runs outside of black terrain")
plot(GPSRunsNoBlack$Runs, col="blue", add=T)

## Runs that did include black terrain
GPSRunsBlack_UUID <- as.character(DistInTerrainClasses$gpsruns_uuid[DistInTerrainClasses$black>0])
GPSRunsBlack <- getRunsObjectFromUUIDs(Oper, GPSRunsBlack_UUID, WithObsPoints = F, WithPausePoints = F)

plot(LocCat, ZoomArea=RunName, ShowSkiRunSegments=T, main="Runs that include black terrain")
plot(GPSRunsBlack$Runs, col="black", add=T)

## Combinded plot
plot(LocCat, ZoomArea=RunName, ShowSkiRunSegments=T, main="Both types of runs")
plot(GPSRunsBlack$Runs, col="black", add=T)
plot(GPSRunsNoBlack$Runs, col="blue", add=T)

}
