% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGPSRunsInLoccatSkirunSummary.R
\name{getGPSRunsInLoccatSkirunSummary}
\alias{getGPSRunsInLoccatSkirunSummary}
\title{Get overview of how many GPS run track with have in skirun polygons.}
\usage{
getGPSRunsInLoccatSkirunSummary(Operation, DateStart,
  DateEnd = DateStart, MinDistInSkirun = 200, ShowProgress = T,
  Verbose = F)
}
\arguments{
\item{Operation}{Name of operation.}

\item{DateStart}{Start date of date range.}

\item{DateEnd}{End date od date range. Default is same as DateStart.}

\item{MinDistInSkirun}{Minimum distance that run has to be in a polygon in m. Default value is 200 m.}

\item{ShowProgress}{Switch whether progress messages should be printed on screen. Default value is T.}

\item{Verbose}{Switch whether queries should be printed on screen. Default value is F.}
}
\value{
Dataframe with list of ski runs with summary statistics about tracks.
}
\description{
Get overview of how many GPS run track with have in skirun polygons.
}
\examples{

require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Oper <- "CMHGL"

DateStart <- "2016-02-01"
DateEnd <- "2016-02-03"

GPSRunSummary <- getGPSRunsInLoccatSkirunSummary(Oper, DateStart, DateEnd)

}
