% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGPSRunsUUIDsFromLoccatSkiRunLineUUIDsNames.R
\name{getGPSRunsUUIDsFromLoccatSkiRunLineUUIDsNames}
\alias{getGPSRunsUUIDsFromLoccatSkiRunLineUUIDsNames}
\title{Gets UUIDs of GPS ski runs that are linked to ski runs or ski lines defined in loccation catalog.}
\usage{
getGPSRunsUUIDsFromLoccatSkiRunLineUUIDsNames(Operation, Names = NA,
  UUIDs = NA)
}
\arguments{
\item{Operation}{Name of operation.}

\item{Names}{Names of loccation catalog ski runs or ski lines}

\item{UUIDs}{UUIDs of loccation catalog ski runs or ski lines}

\item{Verbose}{Switch for printing of query}
}
\value{
Array of GPS run UUIDs
}
\description{
Gets UUIDs of GPS ski runs that are linked to ski runs or ski lines defined in loccation catalog.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Oper <- "NEH"
RunName <- c("White Rabbit", "Jabber Walky")

## Get all GPS runs from these two runs
GPSRuns_UUID <- getGPSRunsUUIDsFromLoccatSkiRunLineUUIDsNames(Oper, Names=RunName)

}
