% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getInfoExMindsetObject.R
\name{getInfoExMindsetObject}
\alias{getInfoExMindsetObject}
\title{Get InfoEx mindset from PostgreSQL/PostGIS GPS database.}
\usage{
getInfoExMindsetObject(Operation, DBType = "Main", DateStart = NA,
  DateEnd = DateStart, Time = "All", LocationName = NA,
  Verbose = F, SuppressPostgreSQLWarnings = T)
}
\arguments{
\item{Operation}{Name of operation}

\item{DBType}{Optional variable for specifying which database type the location catalog should be imported. Values can be 'Main' (default) or 'NodeJS}

\item{DateStart}{Start date in YYYY-MM-DD format. Default value is NA.}

\item{DateEnd}{End date in YYYY-MM-DD format. Default value is DateStart.}

\item{Time}{For specifing time of day of mindset. Values can be 'All' (default), 'Am' or 'PM'.}

\item{LocationName}{Single or array of location names to be associated with mindset (default value is NA)}
}
\description{
Get InfoEx mindset from PostgreSQL/PostGIS GPS database.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Oper <- "CMHGL"

DateStart_Data <- "2015-12-04"
DateEnd_Data   <- "2016-04-01"

Mindset <- getInfoExMindsetObject(Oper, DateStart=DateStart_Data, DateEnd=DateEnd_Data, Time="AM")

}
