% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLocCatlog.R
\name{getLocCatlog}
\alias{getLocCatlog}
\title{Get location catalog}
\usage{
getLocCatlog(Operation, DBType = "Main", LocalProjection = T,
  WithoutDeleted = T, AsCentroidsSkiRuns = F,
  AsCentroidsSkiLines = F, CombineSkiLinesRunsCentroids = F)
}
\arguments{
\item{Operation}{Name of operation}

\item{DBType}{Name of database. Can only be 'Main' (default) or 'NodeJS'}

\item{LocalProjection}{Switch whether location catalog should be projected into local UTM grid. Default is T.}

\item{AsCentroidsSkiRuns}{Switch to specify whether ski runs should be retrieved as point locations at their centroids. Default is F.}

\item{AsCentroidsSkiLines}{Switch to specify whether ski lines should be retrieved as point locations at their centroids. Default is F.}

\item{CombineSkiLinesRunsCentroids}{Switch for combining the centroid of ski lines and ski runs into a single SPDF called SkiAll. Default is F. Is only applied if both AsCentroidsSkiRuns and AsCentroidsSkiLine are TRUE.}

\item{WithoutDelete}{Switch to specify whether location marked as deleted should be omitted. Default is T.}
}
\value{
List with spatial dataframes for each location type in the location catalog.
}
\description{
Get location catalog
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "CMHGL"
LocCat <- getLocCatlog(Operation)

}
