% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRasterValueDfFromRunUUID.R
\name{getRasterValueDfFromRunUUID}
\alias{getRasterValueDfFromRunUUID}
\title{Combines values from specified raster value arrays for list of runs and combines into dataframe.}
\usage{
getRasterValueDfFromRunUUID(Operation, RunUUIDList = NA,
  RasterNames = NA, AddElevBand = T, DBType = "Main",
  SuppressProgressMsgs = F)
}
\arguments{
\item{Operation}{Name of Operation. Used for accessing PostgreSQL database.}

\item{RunUUIDList}{Array of run uuids. Default is NA, which retrieved all records.}

\item{RasterNames}{Array of raster names to be included. By default, all available raster value arrays are included.}

\item{AddElevBand}{Switch to specify whether elevation band labels (BTL, TL, ALP) should be included as additional data frame column.}

\item{DBType}{Optional parameter to specify which database type to get the RunObjects from. Values can be 'Main' (default) or 'NodeJS'.}

\item{SuppressProgressMsgs}{Switch to turn off progress messages. Default is FALSE.}
}
\value{
Object of class 'RasterValueDf': Dataframe with all value pairs for specified runs.
}
\description{
Combines values from specified raster value arrays for list of runs and combines into dataframe.
}
\examples{
 require(SarpGPSTools)
 require(SarpGPSToolsPrivate)
 
 Operation <- "MWHS"
 RunUUIDList <- getRecordsFromQuery(Operation, "Select UUID from gps.qc_runs")$uuid
 RunUUIDList <- RunUUIDList[1:100]
 
 ## Get raster data for all raster arrays
 RasterData <- getRasterValueDfFromRunUUID(Operation, RunUUIDList)
 
 ## Get raster data for a specific raster array
 RasterData <- getRasterValueDfFromRunUUID(Operation, RunUUIDList, "Convexities")
   
}
