% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRecordsFromUUID.R
\name{getRecordsFromUUID}
\alias{getRecordsFromUUID}
\title{Gets record from database based on list of UUID}
\usage{
getRecordsFromUUID(Operation, Schema, DBTbl, DBType = "Main",
  UUID = NA, UUIDCol = "uuid", ForeignUUID = NA,
  ForeignUUIDCol = NA, GeomCol = "geom", ResultCol = NA,
  AddRowNames = T, Verbose = F, SuppressPostgreSQLWarnings = T,
  SuppressOrderWarning = T)
}
\arguments{
\item{Operation}{Name of operation}

\item{Schema}{Name of schema that contains DBTbl}

\item{DBTbl}{Name of database table with geometry}

\item{DBType}{Type of database to query from. Can be 'Main' (default) or 'NodeJS' for database that feeds online viewer.}

\item{UUID}{Single UUID or array of UUIDs. Entire table is returned if no UUID value is provided.}

\item{UUIDCol}{Name of column with UUID in database table}

\item{ForeignUUID}{Single or array of foreign key UUID values for querying table over ForeignUUIDCol.}

\item{ForeignUUIDCol}{Name of foreign key UUID column against which the ForeignUUID values are applied.}

\item{GeomCol}{Name of geometry column to delete it from results dataframe}

\item{ResultCol}{Names of columns included in results table (array of names). UUID column is added automatically. No additional columns are added when an empy string ("") is provided. All columns are returned if no value is provided.}

\item{AddRowNames}{Switch whether uuids should be added as row names}

\item{Verbose}{Switch for printing of query}

\item{SuppressPostgreSQLWarnings}{Switch for suppressing warning messages from postgresqlExecStatement. Turn on for debugging!}

\item{SuppressOrderWarning}{Switch for suppressing warning message about oder of databframe being not the same as the uuid list.}
}
\value{
Dataframe with the specified columns for the provided UUIDs
}
\description{
Gets record from database based on list of UUID
}
