% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRunCharAnswerFreqTbl.R
\name{getRunCharAnswerFreqTbl}
\alias{getRunCharAnswerFreqTbl}
\title{Calculate frequencies of answers.}
\usage{
getRunCharAnswerFreqTbl(RunCharAssessQuestion,
  transformToMinimalLine = F, QuestCode, Operation, QuestDef,
  RunCharMinRelevantSkiLine = NULL, QuestEnum)
}
\arguments{
\item{RunCharAssessQuestion}{Formated data frame.}

\item{transformToMinimalLine}{Switch for transformed answers to minimal comitting line (default=F).}

\item{QuestCode}{Question code.}
}
\value{
Formatted dataframe.
}
\description{
Calculate frequencies of answers.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "NEH"
RunChar <- getRecordsFromUUID(Operation, "runchar", "assessments")
QuestDef <- getRecordsFromQuery(Operation, "SELECT * FROM runchar.questions")
LineLevels <- convertArrayFromSQL(QuestDef[QuestDef$code==QuestCode,]$linelevels,Numeric=F)
ElevLevels <- convertArrayFromSQL(QuestDef[QuestDef$code==QuestCode,]$elevlevels,Numeric=F)
QuestEnum <- getRecordsFromQuery(Operation, paste0("SELECT * FROM runchar.enum_", QuestCode))
RunCharMinRelevantSkiLine <- getRunCharMinRelevantSkiLine(Operation=Operation)

QuestColNames <- getRunCharQuestColNames(QuestCode=QuestCode, Operation=Operation, AssessTblFormatted=F, ElevLevels=ElevLevels)
RunCharCompact <- RunChar[,c("uuid", "loccatskiruns_uuid","loccatskilines_uuid", QuestColNames)]
RunCharCompact <- formatRunCharAssessmentDF(Operation, RunCharCompact)

FreqTbl_Ref <- getRunCharAnswerFreqTbl(RunCharCompact, transformToMinimalLine=T, Operation=Operation, QuestCode=QuestCode, QuestDef=QuestDef, RunCharMinRelevantSkiLine=RunCharMinRelevantSkiLine, QuestEnum=QuestEnum)



}
