% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRunCharAssessments.R
\name{getRunCharAssessments}
\alias{getRunCharAssessments}
\title{Get run character assessments}
\usage{
getRunCharAssessments(Operation, SkirunNames = NA, SkirunUUIDs = NA,
  ClusterNames = NA, ClusterUUIDs = NA, ZoneNames = NA,
  ZoneUUIDs = NA, FormatAssessTbl = T, AddNames = T,
  FromSurveyDB = F, Verbose = F)
}
\arguments{
\item{Operation}{Name of operation}

\item{SkirunNames}{Single or array of skirun names}

\item{SkirunUUIDs}{Single or array of skirun UUIDs}

\item{ClusterNames}{Single or array of cluster names}

\item{ClusterUUIDs}{Single or array of cluster UUIDs}

\item{ZoneNames}{Single or array of zone names}

\item{ZoneUUIDs}{Single or array of skirun UUIDs}

\item{FormatAssessTbl}{Swtich for whether assessment table should be formatted. Default is TRUE.}

\item{AddNames}{Switch for adding run, cluster and zone names. Default is TRUE.}

\item{FromSurveyDB}{Switch for specifying source of run assessments to be survey database}

\item{Verbose}{Switch for printing of query.}
}
\value{
Dataframe with run character assessments
}
\description{
Get run character assessments
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "CMHGL"

## Specific runs
SkirunNames <- c("North Goat", "Alexis")
RunChar_GPSDB <- getRunCharAssessments(Operation, SkirunNames=SkirunNames)
RunChar_Survey <- getRunCharAssessments(Operation, SkirunNames=SkirunNames, FromSurveyDB=T)

## Entire cluster
ClusterNames <- "Wagner Bowls"
RunChar_GPSDB <- getRunCharAssessments(Operation, ClusterNames=ClusterNames)
RunChar_SurveyDB <- getRunCharAssessments(Operation, ClusterNames=ClusterNames, FromSurveyDB=T)

## Entire zone from name
ZoneNames <- "Lake Creek"
RunChar_GPSDB <- getRunCharAssessments(Operation, ZoneNames=ZoneNames)
RunChar_SurveyDB <- getRunCharAssessments(Operation, ZoneNames=ZoneNames, FromSurveyDB=T)

## Entire zone from uuid
ZoneUUID <- "ce345152-10b3-427c-bc8f-4a367b22637e"
RunChar_GPSDB <- getRunCharAssessments(Operation, ZoneUUIDs=ZoneUUID)
RunChar_SurveyDB <- getRunCharAssessments(Operation, ZoneUUIDs=ZoneUUID, FromSurveyDB=T)

}
