% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRunListData.R
\name{getRunListData}
\alias{getRunListData}
\title{Get run list ratings for an operation}
\usage{
getRunListData(Operation, DateStart, DateEnd = DateStart,
  StandardizedCoding = T, ShowSummary = T, DBType = "Main",
  Verbose = F)
}
\arguments{
\item{Operation}{Name of Operation. Used for accessing PostgreSQL database.}

\item{DateStart}{Start date in YYYY-MM-DD format. Default value is NA.}

\item{DateEnd}{End date in YYYY-MM-DD format. Default value is DateStart.}

\item{DBType}{Optional variable for specifying which database type the location catalog should be imported. Values can be 'Main' (default) or 'NodeJS}
}
\value{
dataframe with run list codings.
}
\description{
Get run list ratings for an operation.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)
require(SarpGPSToolsVis)

Operation <- "CMHGL"
DateStart <- "2014-01-01"
DateEnd   <- "2014-03-31"

## get RunList
RunList <- getRunListData(Operation, DateStart = DateStart, DateEnd = DateEnd)

}
