% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRunNamesFromGPSRunsUUID.R
\name{getRunNamesFromGPSRunsUUID}
\alias{getRunNamesFromGPSRunsUUID}
\title{Get names of closest ski line or ski run for gps run from uuid.}
\usage{
getRunNamesFromGPSRunsUUID(Operation, GPSRunsUUIDs,
  MinDistInSkirun = 200, OnlyLongest = F, Verbose = F,
  ShowProgress = T)
}
\arguments{
\item{Operation}{Name of operation.}

\item{GPSRunsUUIDs}{Array of uuids of gps runs}

\item{MinDistInSkirun}{Minimum distance that run has to be in a polygon in m. Default value is 200 m.}

\item{OnlyLongest}{Switch for whether only longest section in polygon should be retained. Default value is F.}
}
\value{
Dataframe with list of skirun/skiline uuids and names, and calculated distances.
}
\description{
Get names of closest ski line or ski run for gps run from uuid.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "CMHGL"

## Get GPS run uuids for GPS unit and day
GPSRunsUUIDs <- getRunUUIDsFromTrackerUnitAndDate(Operation, GpsUnit = '29', DateStart = '2016-01-01')

## Get run usage list with different defaults
RunNamesDefault <- getRunNamesFromGPSRunsUUID(Operation, GPSRunsUUIDs)
RunNamesAll <- getRunNamesFromGPSRunsUUID(Operation, GPSRunsUUIDs, MinDistInSkirun = 0)
RunNamesOnlyOne <- getRunNamesFromGPSRunsUUID(Operation, GPSRunsUUIDs, OnlyLongest = T)

}
