% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRunUUIDsFromTrackerUnitAndDate.R
\name{getRunUUIDsFromTrackerUnitAndDate}
\alias{getRunUUIDsFromTrackerUnitAndDate}
\title{Gets array of run UUIDs form GPS tracker unit and date/date range.}
\usage{
getRunUUIDsFromTrackerUnitAndDate(Operation, GpsUnit = NULL, DateStart,
  DateEnd = DateStart, GuideTypesIncl = NULL, GuideTypesExcl = NULL,
  DBType = "Main", QCOnly = T, Verbose = F,
  SuppressPostgreSQLWarnings = T, SuppressOrderWarning = F)
}
\arguments{
\item{Operation}{Name of operation.}

\item{GpsUnit}{Name of GPS unit.}

\item{DateStart}{Starting date of date range.}

\item{DateEnd}{End date of date range (equal to DateStart by default).}

\item{GuideTypesIncl}{Guides types to include in list (e.g., 'Lead guide', 'Snow safety').}

\item{GuideTypesExcl}{Guides types to include in list (e.g., 'Lead guide', 'Snow safety').}

\item{DBType}{Operational parameter for specifying from which database the run uuids should be retrieved. Values can be 'Main' (default) or 'NodeJS'.}

\item{QCOnly}{Switch for only including quality controlled runs.}

\item{Verbose}{Switch for printing of query}

\item{SuppressPostgreSQLWarnings}{Switch for suppressing warning messages from postgresqlExecStatement. Turn on for debugging!}
}
\value{
Array with run UUIDs
}
\description{
Gets array of run UUIDs form GPS tracker unit and date/date range.
}
