% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRunUsageList.R
\name{getRunUsageList}
\alias{getRunUsageList}
\title{Get run use list for a date and GPS unit}
\usage{
getRunUsageList(Operation, Date, Unit = NULL, MaxDist_M = 1000,
  WithAltitude = NA, WithTime = F, WithUUID = T, DBType = "Main",
  Verbose = F, SuppressPostgreSQLWarnings = T)
}
\arguments{
\item{Operation}{Name of operation.}

\item{Date}{Date for requested run usage list.}

\item{Unit}{Unit label for requested run usage list (default=NULL).}

\item{MaxDist_M}{Maximum distance for proximity calculation in meters.}

\item{WithAltitude}{Flag whether altitude values should be added. Can have values NA, 'dem' or 'gps'.}

\item{WithTime}{Flag whether times should be included. Can be true or false (default).}

\item{WithUUID}{Flag whether UUID of run should be included. Can be true (default) or false.}

\item{DBType}{Optional parameter to specify which database type to create the run usage list from. Values can be 'Main' (default) or 'NodeJS'.}

\item{Verbose}{Switch for printing SQL query. Default value is FALSE.}

\item{SuppressPostgreSQLWarnings}{Switch for turning warnings off}
}
\value{
Dataframe with list of runs, names of closest ski line and distance to ski line.
}
\description{
Get run use list for a date and GPS unit. The name associated with the run is the name of the closest ski line.
}
