% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRunsObjectFromUUIDs.R
\name{getRunsObjectFromUUIDs}
\alias{getRunsObjectFromUUIDs}
\title{Gets RunsObject for single or multiple run UUIDs.}
\usage{
getRunsObjectFromUUIDs(Operation, RunUUIDs, DBType = "Main",
  WithObsPoints = T, WithPausePoints = T, WithRasterValueArrays = F,
  LocalProjection = T)
}
\arguments{
\item{Operation}{name of operation}

\item{RunUUIDs}{Single or array of RunUUIDs}

\item{DBType}{Optional parameter to specify which database type to get the RunObjects from. Values can be 'Main' (default) or 'NodeJS'.}

\item{WithObsPoints}{Switch for whether ObsPoints should be included. Default is TRUE.}

\item{WithPausePoints}{Switch for whether PausePoints should be included. Default is TRUE.}

\item{WithRasterValueArrays}{Switch for whether RasterValueArray should be included. Default is FALSE.}

\item{LocalProjection}{Switch whether location catalog should be projected into local UTM grid. Default is T.}
}
\value{
RunsObject object that includes a list with geometries and data frames for runs(line), observation points (points) and pause points (points) for requested runs.
}
\description{
Gets RunsObject for single or multiple run UUIDs. RunObject object that includes a list with geometries and data frames for runs(line), observation points (points) and pause points (points) for requested runs.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Operation <- "NEH"
RunUUIDs <- getRunUUIDsFromTrackerUnitAndDate(Operation, "13", "2015-02-02")
Runs <- getRunsObjectFromUUIDs(Operation, RunUUIDs)

}
