% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSizeLoccatPolygons.R
\name{getSizeLoccatPolygons}
\alias{getSizeLoccatPolygons}
\title{Gets size of polygons in a location catalog table in km2}
\usage{
getSizeLoccatPolygons(Operation, DBTbl, byid = T)
}
\arguments{
\item{Operation}{Name of operation for accessing correct database}

\item{DBTbl}{Name of database table in loccat schema}

\item{byid}{Switch whether area should be calculated by polygon (i.e., by id) as as total.}
}
\value{
Size of tenure in km2
}
\description{
Gets size of polygons in a location catalog table in km2 (oparea, skiruns)
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Oper <- "CMHGL"

SizeOpArea <- getSizeLoccatPolygons("CMHGL", "oparea")

SizeEachSkiRun <- getSizeLoccatPolygons("CMHGL", "skiruns")
SizeAllSkiRuns <- getSizeLoccatPolygons("CMHGL", "skiruns", byid=F)

}
