% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSpatialObjectsDataFrameFromUUID.R
\name{getSpatialObjectsDataFrameFromUUID}
\alias{getSpatialObjectsDataFrameFromUUID}
\title{Gets spatial data frame from database based on list of UUID}
\usage{
getSpatialObjectsDataFrameFromUUID(Operation, Schema, DBTbl,
  DBType = "Main", UUID = NA, UUIDCol = "uuid", ForeignUUID = NA,
  ForeignUUIDCol = NA, GeomCol = "geom", AsCentroid = F,
  LocalProjection = F, WithoutDeleted = F, ResultCol = NA,
  Verbose = F, SuppressPostgreSQLWarnings = T)
}
\arguments{
\item{Operation}{Name of operation}

\item{Schema}{Name of schema that contains table with geometry}

\item{DBTbl}{Name of database table with geometry}

\item{DBType}{Optional parameter for specifying which database to get the spatial object from}

\item{UUID}{single UUID or array of UUIDs. If NA is provided, the entire table is returned.}

\item{UUIDCol}{Name of column with UUID in database table}

\item{ForeignUUID}{Single or array of foreign key UUID values for querying table over ForeignUUIDCol.}

\item{ForeignUUIDCol}{Name of foreign key UUID column against which the ForeignUUID values are applied.}

\item{GeomCol}{Name of column with geometry in database table}

\item{AsCentroid}{Switch for whether returned geometry should be the centroid. Default value is F.}

\item{LocalProjection}{Switch for whether geometry should be transformed into local UTM coordinate system. Default value is FALSE.}

\item{WithoutDeleted}{Switch to eleiminate locations that are considered deleted. Default is False.}

\item{ResultCol}{Names of columns included in results table (array of names). uuid column is added automatically.}

\item{Verbose}{Switch for printing of query}

\item{SuppressPostgreSQLWarnings}{Switch for supressing warning messages from postgresqlExecStatement. Turn on for debugging!}
}
\value{
Appropriate sp spatial objects (SpatialPoints, SpatialLines, SpatialPolygons)
}
\description{
Conveninece function for directly getting a spatial polygons dataframe from database based on list of UUID
}
