% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSpatialObjectsFromUUID.R
\name{getSpatialObjectsFromUUID}
\alias{getSpatialObjectsFromUUID}
\title{Retrieves spatial objects from PostgreSQl/PostGIS GPS database.}
\usage{
getSpatialObjectsFromUUID(Operation, Schema, DBTbl, DBType = "Main",
  UUID = NA, UUIDCol = "uuid", ForeignUUID = NA,
  ForeignUUIDCol = NA, GeomCol = "geom", AsCentroid = F,
  LocalProjection = F, Verbose = F, SuppressPostgreSQLWarnings = T)
}
\arguments{
\item{Operation}{Name of operation.}

\item{Schema}{Name of schema that contains table with geometry.}

\item{DBTbl}{Name of database table with geometry.}

\item{DBType}{DBType Type of database to create connection with. Can be 'Main' (default) or 'NodeJS' for database that feeds online viewer.}

\item{UUID}{single UUID or array of UUIDs. If NA is provided, the entire table is returned.}

\item{UUIDCol}{Name of column with UUID in database table.}

\item{ForeignUUID}{Single or array of foreign key UUID values for querying table over ForeignUUIDCol.}

\item{ForeignUUIDCol}{Name of foreign key UUID column against which the ForeignUUID values are applied.}

\item{GeomCol}{Name of column with geometry in database table.}

\item{AsCentroid}{Switch for whether returned geometry should be the centroid. Default value is F.}

\item{LocalProjection}{Switch for whether geometry should be transformed into local UTM coordinate system. Default value is FALSE.}

\item{Verbose}{Switch for printing of query. Default value is FALSE.}

\item{SuppressPostgreSQLWarnings}{Switch for supressing warning messages from postgresqlExecStatement. Default value is TRUE. Turn on for debugging!}
}
\value{
Appropriate sp spatial objects (SpatialPoints, SpatialLines, SpatialPolygons)
}
\description{
Retrieves spatial objects from PostgreSQl/PostGIS GPS database and turns them into sp spatial objects.
}
