% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getUUIDsFromNames.R
\name{getUUIDsFromNames}
\alias{getUUIDsFromNames}
\title{Gets UUIDs from names}
\usage{
getUUIDsFromNames(Operation, Schema, DBTbl, DBType = "Main", Names,
  IncludeDeleted = F, Verbose = F, SuppressWarnings = F)
}
\arguments{
\item{Operation}{Name of operation}

\item{Schema}{Name of schema that contains DBTbl}

\item{DBTbl}{Name of database table with geometry}

\item{DBType}{Type of database to query from. Can be 'Main' (default) or 'NodeJS' for database that feeds online viewer.}

\item{Names}{Single or array of names}

\item{Verbose}{Switch for printing of query.}

\item{SuppressWarnings}{Switch for whether warnings should be suppressed. Default is FALSE.}
}
\value{
Single UUID or array of UUID
}
\description{
Gets UUID from single or array of names
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Oper <- "CMHGL"
SkirunNames <- c("North Goat", "Alexis")

SkirunUUIDs <- getUUIDsFromNames(Operation=Oper, Schema="loccat", DbTbl="skiruns", Names=SKirunNames)
}
