% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importElevBandBoundariesFromContourShp.R
\name{importElevBandBoundariesFromContourShp}
\alias{importElevBandBoundariesFromContourShp}
\title{Import contour lines for elevation band boundaries from shp file and write into PostgreSQL/PostGIS GPS database.}
\usage{
importElevBandBoundariesFromContourShp(Operation, User, DBType = "Main",
  FileName = "contour", ElevBTL2TL = NA, ElevTL2ALP = NA,
  Overwrite = F)
}
\arguments{
\item{Operation}{Name of operation}

\item{User}{Name of user. Required for getting correct local folder path to contour shapefile.}

\item{DBType}{Optional parameter for specifying which database type the cat roads should be imported to. Values can be 'Main' (default) or 'NodeJS'.}

\item{FileName}{Name of shape file with contour lines. Defailt avalue is 'contour'}

\item{ElevBTL2TL}{Elevation of below treeline - treeline elevation band boundary. If NA (default), values is extracted from database.}

\item{ElevTL2ALP}{Elevation of treeline - alpine elevation band boundary. If NA (default), values is extracted from database.}

\item{Overwrite}{Boolean flag for whether the entire catroad table should be overwritten (i.e., all records deleted first). Default is F.}
}
\description{
Import contour lines for elevation band boundaries from shp file and write into PostgreSQL/PostGIS GPS database.
}
\examples{
require(SarpGPSToolsPrivate)
require(SarpGPSTools)

Operation <- "MPS"
User <- "SarpLab"

importElevBandBoundariesFromContourShp(Operation, User)

}
